#include <cstdio>
#include <cstring>
#include <algorithm>
#include <cassert>

using namespace std;

const int MAXN = 2010;
const int MODULO = 1000000000 + 7;

//typedef unsigned ll ull;
typedef long long ll;

ll N;
ll D;
int X;
int sums[MAXN];
int d[MAXN][MAXN];
ll rev[MAXN];

void buildSums(int day) {
	sums[0] = d[day][0];
	for(int i = 1; i < MAXN; i++) {
		sums[i] = sums[i - 1] + d[day][i];
		if(sums[i] >= MODULO)
			sums[i] -= MODULO;
	}
}

inline int getSum(int l, int r) {
	int result = sums[r] - ((l == 0) ? 0 : sums[l - 1]);
	if(result < 0)
		result += MODULO;
	return result;
}

ll factorial(ll n) {
	ll result = 1;
	for(ll i = 2; i <= n; i++) {
		result *= i;
	}
	return result;
}

ll C(ll n, ll k) {
	assert(k < MAXN);
	ll start = n - k + 1;
	ll end = n;
	ll result = 1;
	for(ll i = start; i <= end; i++) {
		result = (result * (i % MODULO)) % MODULO;
	}
	result = (result * rev[k]) % MODULO;
	return result;
}

void solve() {
	if(X == 1) {
		printf("0\n");
	} else {
		memset(d, 0, sizeof(d));
		d[0][0] = 1;
		for(int day = 1; day <= min(D, N); day++) {
			buildSums(day - 1);
			for(int already = 1; already <= N; already++) {
				int l = max(0, already - X + 1);
				int r = already - 1;
				assert(l <= r);
				d[day][already] = getSum(l, r);
			}
		}
		ll result = 0;
		for(int day = 1; day <= min(D, N); day++) {
			result += d[day][N] * C(D, day);
			result %= MODULO;
		}
		result %=  MODULO;
		printf("%d\n", result);
	}
}

ll getPow(ll n, ll p, ll m) {
	ll result = 1;
	while(p != 0) {
		if((p & 1) != 0) {
			result = (result * n) % m;
		}
		n = (n * n) % m;
		p >>= 1;
	}
	return result;
}

void build() {
	ll value = 1;
	rev[0] = rev[1] = value;
	for(ll i = 2; i < MAXN; i++) {
		value = (value * i) % MODULO;
		rev[i] = getPow(value, MODULO - 2, MODULO);
	}
}

int main() {
	build();
	while(true) {
		scanf("%lld%lld%d", &N, &D, &X);
		if(N == 0) break;
		solve();
	}
	return 0;
}